package gov.va.med.mhv.vitals.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="OximeterValidator")
public class OximeterValidator implements Validator  {
	
	private static final  String OXIMETER_SUMMARY1 = "The Oximeter Reading value must be greater than or equal to 50.";
	private static final  String OXIMETER_SUMMARY2 = "The Oximeter Reading value must be less than or equal to 100.";
	

	
	private static final  String  OXIMETER_DETAIL1="Enter a value greater than or equal to 50.";
	private static final  String  OXIMETER_DETAIL2="Enter a value less than or equal to 100.";
	
	
	private static final Integer OXIMETER__MIN_VALUE = new Integer("50");
	private static final Integer OXIMETER_MAX_VALUE = new Integer("100");


	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
		Integer oximeterValue =null;
		if(value != null){
			oximeterValue =(Integer)value;
		}
		 if(oximeterValue != null ){
			 if(oximeterValue.compareTo(OXIMETER_MAX_VALUE) > 0){
				   throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, OXIMETER_SUMMARY2, OXIMETER_DETAIL2));
			 }else  if(oximeterValue.compareTo(OXIMETER__MIN_VALUE) < 0){
				   throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, OXIMETER_SUMMARY1, OXIMETER_DETAIL1));
			 }
		 }
	}
}
